/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MassProperties.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CAssembly.h"
#include "CApplication.h"


HRESULT Massproperties(double *mass, double *volume, double *area, 
					IVector *cofgPoint, IMatrix *momentOfInertia, IVector *principalMomentsOfInertia, IMatrix *principalAxes,
					IVector *radiusOfGyration)
{

//	Returns the geometric properties (volume,volume Error,area,area Error)
//	of the active design

	START_METHOD("Mass Properties")

	HRESULT status = CONV_SUCCESS ;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *design = NULL ;

	status = activePart->GetDesign(&design) ;
	CHECK_RETURN_STATUS(status)

	status = design->GetGeometricProperties(mass, volume, area, 
					&cofgPoint, &momentOfInertia, &principalMomentsOfInertia, &principalAxes,
					&radiusOfGyration);
	CHECK_RETURN_STATUS(status)

	END_METHOD("Mass Properties")
}
